// wadTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "wadTest.h"
#include "../genList.h"
#include "../fableWad.h"
#include "wadTestDlg.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWadTestDlg dialog

CWadTestDlg::CWadTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWadTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWadTestDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	strWadFileName = "";
}

void CWadTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWadTestDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWadTestDlg, CDialog)
	//{{AFX_MSG_MAP(CWadTestDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OPEN_WAD, OnOpenWad)
	ON_BN_CLICKED(IDC_SORT_FILES, OnSortFiles)
	ON_BN_CLICKED(IDC_EXPORT_FILE, OnExportFile)
	ON_BN_CLICKED(IDC_DIR_EXPORT, OnDirExport)
	ON_BN_CLICKED(IDC_IMPORT_FILE, OnImportFile)
	ON_BN_CLICKED(IDC_QUEUE_IMPORT, OnQueueImport)
	ON_BN_CLICKED(IDC_IMPORT_QUEUED, OnImportQueued)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWadTestDlg message handlers

BOOL CWadTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWadTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWadTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CWadTestDlg::UpdateWadFileList()
{
	CListBox* pListBox = (CListBox*) GetDlgItem( IDC_WAD_FILE_LIST );
	pListBox->ResetContent();

	CButton* pSortCheck = (CButton*) GetDlgItem( IDC_SORT_FILES );

	DWORD dwSize = cWad.FileCount();
	for(DWORD i = 0; i < dwSize; i++)
	{
		CFileInfo* pCurFile = cWad.GetFile(i);
		if(pSortCheck->GetCheck() == 1)
		{
			pListBox->AddString( pCurFile->fileName );
		}
		else
		{
			pListBox->InsertString( (int)i, pCurFile->fileName );
		}
	}
}

void CWadTestDlg::UpdateQueuedFileList()
{
	CListBox* pListBox = (CListBox*) GetDlgItem( IDC_IMPORT_QUEUE );
	pListBox->ResetContent();

	DWORD dwSize = cWad.FileCount();
	for(DWORD i = 0; i < dwSize; i++)
	{
		CFileInfo* pCurFile = cWad.GetFile(i);
		if(pCurFile->inputFilename[0] != 0)
		{
			// @##$$# horizontal scroll BS....
			char lpszItem[2048];
			strcpy(lpszItem, CString(pCurFile->fileName) + " <-- " + pCurFile->inputFilename );
			CClientDC dc ( pListBox ) ;
			CSize size = dc.GetTextExtent ( lpszItem, strlen(lpszItem) ) ;
			if ( size.cx > pListBox->GetHorizontalExtent( ) )
				pListBox->SetHorizontalExtent ( size.cx ) ;
			
			pListBox->AddString( lpszItem );
		}
	}
}

void CWadTestDlg::OnOpenWad() 
{
	CString txt;
	OPENFILENAME o;
	char buffer[256];

	lstrcpy(buffer, "*.wad");

	memset(&o, 0, sizeof(o));

	o.lStructSize = sizeof(o);
	o.hwndOwner = GetSafeHwnd();
	o.lpstrFilter = "Fable Wad Files (*.wad)\0*.wad\0\0";
	o.nFilterIndex = 1;
	o.lpstrFile = buffer;
	o.nMaxFile = sizeof(buffer);
	o.lpstrTitle = "Open Fable Wad File";
	o.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
 
	if (GetOpenFileName(&o))
	{
		if(cWad.Open(o.lpstrFile))
		{
			strWadFileName = o.lpstrFile;
			SetDlgItemText(IDC_FILE_NAME, o.lpstrFile);
			//fill in the list of files
			UpdateWadFileList();
		}
	}
}

int CWadTestDlg::TestWadFileSel()
{
	CListBox* pListBox = (CListBox*) GetDlgItem( IDC_WAD_FILE_LIST );
	int nRet = pListBox->GetCurSel( );
	if(nRet == LB_ERR)
	{
		AfxMessageBox("Select a file from the wad first. :-)");
	}
	return nRet;
}

void CWadTestDlg::OnSortFiles() 
{
	UpdateWadFileList();
}

void CWadTestDlg::OnExportFile() 
{
	int nIndex = TestWadFileSel();
	if(nIndex == LB_ERR)
		return;
	CListBox* pListBox = (CListBox*) GetDlgItem( IDC_WAD_FILE_LIST );
	CString fileName = "";
	pListBox->GetText( nIndex, fileName);
	
	// have to strip off dir names
	CString fileNameOnly = fileName;
	while(fileNameOnly.Find('\\') != -1)
	{
		//deleting the first char over and over unfil will kill all the backslashes
		// cheap I know.  makes me feel dirty...
		fileNameOnly = fileNameOnly.Right(fileNameOnly.GetLength() - 1);
	}


	//bring up a save as dialog box

	OPENFILENAME ofn;
	char buffer[MAX_PATH];

	lstrcpy(buffer, fileNameOnly);
	
    memset( &(ofn), 0, sizeof(ofn));
    ofn.lStructSize   = sizeof(ofn);
    ofn.hwndOwner = GetSafeHwnd();;
    ofn.lpstrFile = buffer;
    ofn.nMaxFile = MAX_PATH;   
	ofn.lpstrFilter = "All Files (*.*)\0*.*\0";
	ofn.nFilterIndex = 1;
    ofn.lpstrTitle = "Export File From Wad";
    ofn.Flags = OFN_HIDEREADONLY; 
    ofn.lpstrDefExt = "\0";
    if (GetSaveFileName(&ofn))   
	{
		cWad.ExtractFile(fileName, ofn.lpstrFile);
	}
}


void CWadTestDlg::OnDirExport() 
{
	CString strFolder = "";
	if(!BrowseForFolder(GetSafeHwnd(), strFolder))
		return;
	CWaitCursor cWait;
	CString text;
	GetWindowText(text);
	SetWindowText(text + " ( Exporting... )");
	cWad.DirectoryExport(strFolder);	
	SetWindowText(text);
	cWait.Restore();
}

void CWadTestDlg::OnImportFile() 
{
	int nIndex = TestWadFileSel();
	if(nIndex == LB_ERR)
		return;
	CListBox* pListBox = (CListBox*) GetDlgItem( IDC_WAD_FILE_LIST );
	CString fileName = "";
	pListBox->GetText( nIndex, fileName);
	
	// have to strip off dir names
	CString fileNameOnly = fileName;
	while(fileNameOnly.Find('\\') != -1)
	{
		//deleting the first char over and over unfil will kill all the backslashes
		// cheap I know.  makes me feel dirty...
		fileNameOnly = fileNameOnly.Right(fileNameOnly.GetLength() - 1);
	}

	//bring up open dialog box
	OPENFILENAME ofn;
	char buffer[MAX_PATH];
	lstrcpy(buffer, fileNameOnly);
    memset( &(ofn), 0, sizeof(ofn));
    ofn.lStructSize   = sizeof(ofn);
    ofn.hwndOwner = GetSafeHwnd();;
    ofn.lpstrFile = buffer;
    ofn.nMaxFile = MAX_PATH;   
	ofn.lpstrFilter = "All Files (*.*)\0*.*\0";
	ofn.nFilterIndex = 1;
    ofn.lpstrTitle = "Import File Into Wad";
    ofn.Flags = OFN_HIDEREADONLY; 
    ofn.lpstrDefExt = "\0";
    if (GetOpenFileName(&ofn))
	{
		if(!cWad.InjectFile(fileName, ofn.lpstrFile))
		{
			if(
				AfxMessageBox(
					"This file is so big that we'll have to rebuild and expand the wad file to accommodate it.\n\nWould you like to add it to the queue of files to be imported instead?",
					MB_YESNO ) == IDYES
				)
			{
				cWad.QueueInjection(fileName, ofn.lpstrFile);
				UpdateQueuedFileList();
			}
		}
	}
}

void CWadTestDlg::OnQueueImport() 
{
	int nIndex = TestWadFileSel();
	if(nIndex == LB_ERR)
		return;
	CListBox* pListBox = (CListBox*) GetDlgItem( IDC_WAD_FILE_LIST );
	CString fileName = "";
	pListBox->GetText( nIndex, fileName);
	
	// have to strip off dir names
	CString fileNameOnly = fileName;
	while(fileNameOnly.Find('\\') != -1)
	{
		//deleting the first char over and over unfil will kill all the backslashes
		// cheap I know.  makes me feel dirty...
		fileNameOnly = fileNameOnly.Right(fileNameOnly.GetLength() - 1);
	}

	//bring up open dialog box
	OPENFILENAME ofn;
	char buffer[MAX_PATH];
	lstrcpy(buffer, fileNameOnly);
    memset( &(ofn), 0, sizeof(ofn));
    ofn.lStructSize   = sizeof(ofn);
    ofn.hwndOwner = GetSafeHwnd();;
    ofn.lpstrFile = buffer;
    ofn.nMaxFile = MAX_PATH;   
	ofn.lpstrFilter = "All Files (*.*)\0*.*\0";
	ofn.nFilterIndex = 1;
    ofn.lpstrTitle = "Import File Into Wad";
    ofn.Flags = OFN_HIDEREADONLY; 
    ofn.lpstrDefExt = "\0";
    if (GetOpenFileName(&ofn))
	{
		cWad.QueueInjection(fileName, ofn.lpstrFile);
		UpdateQueuedFileList();
	}
}

void CWadTestDlg::OnImportQueued() 
{
	// have to strip off dir names
	CString fileNameOnly = strWadFileName;
	while(fileNameOnly.Find('\\') != -1)
	{
		//deleting the first char over and over unfil will kill all the backslashes
		// cheap I know.  makes me feel dirty...
		fileNameOnly = fileNameOnly.Right(fileNameOnly.GetLength() - 1);
	}

	//bring up a save as dialog box

	OPENFILENAME ofn;
	char buffer[MAX_PATH];

	lstrcpy(buffer, fileNameOnly);
	
    memset( &(ofn), 0, sizeof(ofn));
    ofn.lStructSize   = sizeof(ofn);
    ofn.hwndOwner = GetSafeHwnd();;
    ofn.lpstrFile = buffer;
    ofn.nMaxFile = MAX_PATH;   
	ofn.lpstrFilter = "Fable Wad Files (*.wad)\0*.wad\0\0";
	ofn.nFilterIndex = 1;
    ofn.lpstrTitle = "Build a New Wad File";
    ofn.Flags = OFN_HIDEREADONLY; 
    ofn.lpstrDefExt = "\0";
    if (GetSaveFileName(&ofn))   
	{
		CWaitCursor cWait;
		CString text;
		GetWindowText(text);
		SetWindowText(text + " ( Rebuilding... )");
		cWad.DumpWad(ofn.lpstrFile);
		SetWindowText(text);
		cWait.Restore();
	}
	AfxMessageBox("New Wad File had been built.");
	UpdateQueuedFileList();

}
