/*
 * FableTools.h
 *
 * First things first, mad props to Fatum who put theroy into practice.  The guts of these 
 * classes are derived from his code.  I'm just making it look pretty and easy to use.  Also,
 * having a class means you don't have to worry about changing your code when we find out 
 * something new.  Just download the new class and compile it!
 * -bigfreak
 *
 * Big Thanks to Amins and Mods at http://fable.lanpirates.net for bringing us together.
 * 
 * irc.dynastynet.net
 * #fablehax
 */

#ifndef _FABLETOOLS_H_
#define _FABLETOOLS_H_

//man, putting this on the xbox need to make sure some of this stuff is defined
#ifndef DWORD
typedef unsigned long DWORD;
#endif
#ifndef NULL
#define NULL 0
#endif
#ifndef BOOL
typedef int BOOL;
#endif
#ifndef TRUE
#define TRUE -1
#endif
#ifndef FALSE
#define FALSE 0
#endif


//wad file header data
typedef struct	_WADHEADER
{
  char bbbb[8];
  int fileversion;		// wad file version?
  int subversion;		// sub version?
  int blocksize;		// size of the blocks read
  int nofiles;			// number of files in the wad
  int ilosc;			// number of files repeated
  int start;			// start of file header data
}WADHEADER;


//file header for each file in the wad (part a)
typedef struct	_FILEHEADER_A
{
  int unknown1;
  int unknown2;
  int unknown3;
  int unknown4;
  int Fileno;
  int unknown5;
  int size;
  int adress;
  int unknown6;
  int namesize;
} FILEHEADER_A;

//file header part b.
/*
 * We need two parts because the filename sits between part A and part B and the
 * size of that string changes from file to file.  If we break it up this way,
 * it we can use pointers to get out the data and that makes life easy.
 */

typedef struct	_FILEHEADER_B
{
  int unknown1;
  int unknown2;
  int unknown3;
  int unknown4;
  int year1;
  int month1;
  int day1;
  int hour1;
  int minute1;
  int second1;
  int ssecond1;
  int year2;
  int month2;
  int day2;
  int hour2;
  int minute2;
  int second2;
  int ssecond2;
  int year3;
  int month3;
  int day3;
  int hour3;
  int minute3;
} FILEHEADER_B;


class CFileInfo
{
public:
	CFileInfo();
	CFileInfo(const char* filename, DWORD inSize, 
				DWORD inAddress, DWORD inHeader, DWORD inMaxsize);
	~CFileInfo();
	CFileInfo* Copy();
	void QueueFile(const char* inputFile);
public:
//private:

	char fileName[2048];		//filename stored in the wad
	DWORD dwSize;				//size of the file
	DWORD dwAddress;			//address of the file in the wad
	DWORD dwHeader;				//address of the header?
	DWORD dwMaxsize;			//max size the file can be

	char inputFilename[2048];	//used only for queued imports
};

class CWad
{
public:
	CWad();
	~CWad();
	BOOL Open(const char* inputWadFile);//stores the file name and primes the file list
	void Close();						//resets the file list and removes the filename
	DWORD FileCount();					//returns number of files in the wad
	CFileInfo* GetFile(					//returns a CFileInfo object (bCopy returns a 
			DWORD dwIndex,				// pointer you can delete[]) otherwise your delete[] 
			BOOL bCopy = FALSE);		// will cause a crash later
	BOOL ExtractFile(					//extracts a file from the wad
			DWORD dwIndex, 
			const char* outFilename);	
	BOOL ExtractFile(					//same as above but we reference extracted file as string
			const char* extractFile, 
			const char* outFilename);
	BOOL InjectFile(					//injects a file into the wad imediately
			DWORD dwIndex,				//	must be smaller than maxsize
			const char* inFilename);
	BOOL InjectFile(					//same as above but we reference replaced file as string
			const char* replaceFile,
			const char* inFilename);
	BOOL InjectLargeFile(				//injects a file larger than maxsize into the wad
			DWORD dwIndex,				//  it's done imediately and you must give an output
			const char* inFilename,		//  filename for the resulting wad (can't be the same)
			const char* outputWadFile);	
	BOOL InjectLargeFile(				//same as above but we reference replaced file as string
			const char* replaceFile,
			const char* inFilename,
			const char* outputWadFile);	
	BOOL QueueInjection(				//queues a file for injection.  regardless of how big
			DWORD dwIndex,				// the file is, it gets written to the wad in DumpWad()
			const char* inFilename);
	BOOL QueueInjection(				//same as above but we reference replaced file as string
			const char* replaceFile,
			const char* inFilename);
	BOOL DumpWad(						//creates a new wad file from queued file operations
			const char* outputWadFile);
	BOOL DirectoryExport(				//exracts the entire wad to a directory
			const char* dirPath);	
	BOOL DirectoryImport(				//this will take a directory and make a wad out
			const char* dirPath);		// of it  (not implemented yet)
	DWORD GetIndex(const char* file);	//returns the index of the given file name
private:
	BOOL PrimeFileList();				//private function that enumerates files in the wad

	GenList fileList;					//list of files in the wad
	char fileName[2048];				//full path and filename of wad
	BOOL bOpen;							//true when we have a filename and list of Files
};


#endif